/*
 * Decompiled with CFR 0.152.
 */
package soot;

import heros.solver.CountingThreadPoolExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AbstractJasminClass;
import soot.Body;
import soot.BodyPack;
import soot.ClassSource;
import soot.CompilationDeathException;
import soot.G;
import soot.HasPhaseOptions;
import soot.JavaToJimpleBodyPack;
import soot.JimpleBodyPack;
import soot.Pack;
import soot.PhaseOptions;
import soot.Printer;
import soot.Scene;
import soot.ScenePack;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Transform;
import soot.Transformer;
import soot.XMLAttributesPrinter;
import soot.baf.Baf;
import soot.baf.BafASMBackend;
import soot.baf.BafBody;
import soot.baf.toolkits.base.LoadStoreOptimizer;
import soot.baf.toolkits.base.PeepholeOptimizer;
import soot.baf.toolkits.base.StoreChainOptimizer;
import soot.coffi.CFG;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.DavaBuildFile;
import soot.dava.DavaPrinter;
import soot.dava.DavaStaticBlockCleaner;
import soot.dava.toolkits.base.AST.interProcedural.InterProceduralAnalyses;
import soot.dava.toolkits.base.AST.transformations.RemoveEmptyBodyDefaultConstructor;
import soot.dava.toolkits.base.AST.transformations.VoidReturnRemover;
import soot.dava.toolkits.base.misc.PackageNamer;
import soot.dava.toolkits.base.misc.ThrowFinder;
import soot.grimp.Grimp;
import soot.grimp.GrimpBody;
import soot.grimp.toolkits.base.ConstructorFolder;
import soot.jbco.Main;
import soot.jimple.JasminClass;
import soot.jimple.JimpleBody;
import soot.jimple.paddle.PaddleHook;
import soot.jimple.spark.SparkTransformer;
import soot.jimple.spark.fieldrw.FieldTagAggregator;
import soot.jimple.spark.fieldrw.FieldTagger;
import soot.jimple.toolkits.annotation.AvailExprTagger;
import soot.jimple.toolkits.annotation.DominatorsTagger;
import soot.jimple.toolkits.annotation.LineNumberAdder;
import soot.jimple.toolkits.annotation.arraycheck.ArrayBoundsChecker;
import soot.jimple.toolkits.annotation.arraycheck.RectangularArrayFinder;
import soot.jimple.toolkits.annotation.callgraph.CallGraphGrapher;
import soot.jimple.toolkits.annotation.callgraph.CallGraphTagger;
import soot.jimple.toolkits.annotation.defs.ReachingDefsTagger;
import soot.jimple.toolkits.annotation.fields.UnreachableFieldsTagger;
import soot.jimple.toolkits.annotation.liveness.LiveVarsTagger;
import soot.jimple.toolkits.annotation.logic.LoopInvariantFinder;
import soot.jimple.toolkits.annotation.methods.UnreachableMethodsTagger;
import soot.jimple.toolkits.annotation.nullcheck.NullCheckEliminator;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerChecker;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerColorer;
import soot.jimple.toolkits.annotation.parity.ParityTagger;
import soot.jimple.toolkits.annotation.profiling.ProfilingGenerator;
import soot.jimple.toolkits.annotation.purity.PurityAnalysis;
import soot.jimple.toolkits.annotation.qualifiers.TightestQualifiersTagger;
import soot.jimple.toolkits.annotation.tags.ArrayNullTagAggregator;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.base.RenameDuplicatedClasses;
import soot.jimple.toolkits.callgraph.CHATransformer;
import soot.jimple.toolkits.callgraph.CallGraphPack;
import soot.jimple.toolkits.callgraph.UnreachableMethodTransformer;
import soot.jimple.toolkits.invoke.StaticInliner;
import soot.jimple.toolkits.invoke.StaticMethodBinder;
import soot.jimple.toolkits.pointer.CastCheckEliminatorDumper;
import soot.jimple.toolkits.pointer.DependenceTagAggregator;
import soot.jimple.toolkits.pointer.ParameterAliasTagger;
import soot.jimple.toolkits.pointer.SideEffectTagger;
import soot.jimple.toolkits.reflection.ConstantInvokeMethodBaseTransformer;
import soot.jimple.toolkits.scalar.CommonSubexpressionEliminator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.EmptySwitchEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.scalar.pre.BusyCodeMotion;
import soot.jimple.toolkits.scalar.pre.LazyCodeMotion;
import soot.jimple.toolkits.thread.mhp.MhpTransformer;
import soot.jimple.toolkits.thread.synchronization.LockAllocator;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleTransformer;
import soot.shimple.toolkits.scalar.SConstantPropagatorAndFolder;
import soot.sootify.TemplatePrinter;
import soot.tagkit.InnerClassTagAggregator;
import soot.tagkit.LineNumberTagAggregator;
import soot.toDex.DexPrinter;
import soot.toolkits.exceptions.DuplicateCatchAllTrapRemover;
import soot.toolkits.exceptions.TrapTightener;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.ConstantInitializerToTagTransformer;
import soot.toolkits.scalar.ConstantValueToInitializerTransformer;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.SharedInitializationLocalSplitter;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.EscapedWriter;
import soot.util.JasminOutputStream;
import soot.util.PhaseDumper;
import soot.xml.TagCollector;
import soot.xml.XMLPrinter;

public class PackManager {
    private static final Logger logger = LoggerFactory.getLogger(PackManager.class);
    public static boolean DEBUG = false;
    private final Map<String, Pack> packNameToPack = new HashMap<String, Pack>();
    private final List<Pack> packList = new LinkedList<Pack>();
    private boolean onlyStandardPacks = false;
    private JarOutputStream jarFile = null;
    protected DexPrinter dexPrinter = null;

    public PackManager(Singletons.Global g) {
        PhaseOptions.v().setPackManager(this);
        this.init();
    }

    public static PackManager v() {
        return G.v().soot_PackManager();
    }

    public boolean onlyStandardPacks() {
        return this.onlyStandardPacks;
    }

    void notifyAddPack() {
        this.onlyStandardPacks = false;
    }

    private void init() {
        JimpleBodyPack p = new JimpleBodyPack();
        this.addPack((Pack)p);
        p.add(new Transform("jb.tt", (Transformer)TrapTightener.v()));
        p.add(new Transform("jb.dtr", (Transformer)DuplicateCatchAllTrapRemover.v()));
        p.add(new Transform("jb.ese", (Transformer)EmptySwitchEliminator.v()));
        p.add(new Transform("jb.ls", (Transformer)LocalSplitter.v()));
        p.add(new Transform("jb.sils", (Transformer)SharedInitializationLocalSplitter.v()));
        p.add(new Transform("jb.a", (Transformer)Aggregator.v()));
        p.add(new Transform("jb.ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jb.tr", (Transformer)TypeAssigner.v()));
        p.add(new Transform("jb.ulp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jb.lns", (Transformer)LocalNameStandardizer.v()));
        p.add(new Transform("jb.cp", (Transformer)CopyPropagator.v()));
        p.add(new Transform("jb.dae", (Transformer)DeadAssignmentEliminator.v()));
        p.add(new Transform("jb.cp-ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jb.lp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jb.ne", (Transformer)NopEliminator.v()));
        p.add(new Transform("jb.uce", (Transformer)UnreachableCodeEliminator.v()));
        p.add(new Transform("jb.cbf", (Transformer)ConditionalBranchFolder.v()));
        p = new JavaToJimpleBodyPack();
        this.addPack((Pack)p);
        p.add(new Transform("jj.ls", (Transformer)LocalSplitter.v()));
        p.add(new Transform("jj.sils", (Transformer)SharedInitializationLocalSplitter.v()));
        p.add(new Transform("jj.a", (Transformer)Aggregator.v()));
        p.add(new Transform("jj.ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jj.ne", (Transformer)NopEliminator.v()));
        p.add(new Transform("jj.tr", (Transformer)TypeAssigner.v()));
        p.add(new Transform("jj.ulp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jj.lns", (Transformer)LocalNameStandardizer.v()));
        p.add(new Transform("jj.cp", (Transformer)CopyPropagator.v()));
        p.add(new Transform("jj.dae", (Transformer)DeadAssignmentEliminator.v()));
        p.add(new Transform("jj.cp-ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jj.lp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jj.uce", (Transformer)UnreachableCodeEliminator.v()));
        p = new ScenePack("wjpp");
        this.addPack((Pack)p);
        p.add(new Transform("wjpp.cimbt", (Transformer)ConstantInvokeMethodBaseTransformer.v()));
        p = new ScenePack("wspp");
        this.addPack((Pack)p);
        p = new CallGraphPack("cg");
        this.addPack((Pack)p);
        p.add(new Transform("cg.cha", (Transformer)CHATransformer.v()));
        p.add(new Transform("cg.spark", (Transformer)SparkTransformer.v()));
        p.add(new Transform("cg.paddle", (Transformer)PaddleHook.v()));
        p = new ScenePack("wstp");
        this.addPack((Pack)p);
        p = new ScenePack("wsop");
        this.addPack((Pack)p);
        p = new ScenePack("wjtp");
        this.addPack((Pack)p);
        p.add(new Transform("wjtp.mhp", (Transformer)MhpTransformer.v()));
        p.add(new Transform("wjtp.tn", (Transformer)LockAllocator.v()));
        p.add(new Transform("wjtp.rdc", (Transformer)RenameDuplicatedClasses.v()));
        p = new ScenePack("wjop");
        this.addPack((Pack)p);
        p.add(new Transform("wjop.smb", (Transformer)StaticMethodBinder.v()));
        p.add(new Transform("wjop.si", (Transformer)StaticInliner.v()));
        p = new ScenePack("wjap");
        this.addPack((Pack)p);
        p.add(new Transform("wjap.ra", (Transformer)RectangularArrayFinder.v()));
        p.add(new Transform("wjap.umt", (Transformer)UnreachableMethodsTagger.v()));
        p.add(new Transform("wjap.uft", (Transformer)UnreachableFieldsTagger.v()));
        p.add(new Transform("wjap.tqt", (Transformer)TightestQualifiersTagger.v()));
        p.add(new Transform("wjap.cgg", (Transformer)CallGraphGrapher.v()));
        p.add(new Transform("wjap.purity", (Transformer)PurityAnalysis.v()));
        p = new BodyPack("shimple");
        this.addPack((Pack)p);
        p = new BodyPack("stp");
        this.addPack((Pack)p);
        p = new BodyPack("sop");
        this.addPack((Pack)p);
        p.add(new Transform("sop.cpf", (Transformer)SConstantPropagatorAndFolder.v()));
        p = new BodyPack("jtp");
        this.addPack((Pack)p);
        p = new BodyPack("jop");
        this.addPack((Pack)p);
        p.add(new Transform("jop.cse", (Transformer)CommonSubexpressionEliminator.v()));
        p.add(new Transform("jop.bcm", (Transformer)BusyCodeMotion.v()));
        p.add(new Transform("jop.lcm", (Transformer)LazyCodeMotion.v()));
        p.add(new Transform("jop.cp", (Transformer)CopyPropagator.v()));
        p.add(new Transform("jop.cpf", (Transformer)ConstantPropagatorAndFolder.v()));
        p.add(new Transform("jop.cbf", (Transformer)ConditionalBranchFolder.v()));
        p.add(new Transform("jop.dae", (Transformer)DeadAssignmentEliminator.v()));
        p.add(new Transform("jop.nce", (Transformer)new NullCheckEliminator()));
        p.add(new Transform("jop.uce1", (Transformer)UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf1", (Transformer)UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.uce2", (Transformer)UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf2", (Transformer)UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.ule", (Transformer)UnusedLocalEliminator.v()));
        p = new BodyPack("jap");
        this.addPack((Pack)p);
        p.add(new Transform("jap.npc", (Transformer)NullPointerChecker.v()));
        p.add(new Transform("jap.npcolorer", (Transformer)NullPointerColorer.v()));
        p.add(new Transform("jap.abc", (Transformer)ArrayBoundsChecker.v()));
        p.add(new Transform("jap.profiling", (Transformer)ProfilingGenerator.v()));
        p.add(new Transform("jap.sea", (Transformer)SideEffectTagger.v()));
        p.add(new Transform("jap.fieldrw", (Transformer)FieldTagger.v()));
        p.add(new Transform("jap.cgtagger", (Transformer)CallGraphTagger.v()));
        p.add(new Transform("jap.parity", (Transformer)ParityTagger.v()));
        p.add(new Transform("jap.pat", (Transformer)ParameterAliasTagger.v()));
        p.add(new Transform("jap.rdtagger", (Transformer)ReachingDefsTagger.v()));
        p.add(new Transform("jap.lvtagger", (Transformer)LiveVarsTagger.v()));
        p.add(new Transform("jap.che", (Transformer)CastCheckEliminatorDumper.v()));
        p.add(new Transform("jap.umt", (Transformer)new UnreachableMethodTransformer()));
        p.add(new Transform("jap.lit", (Transformer)LoopInvariantFinder.v()));
        p.add(new Transform("jap.aet", (Transformer)AvailExprTagger.v()));
        p.add(new Transform("jap.dmt", (Transformer)DominatorsTagger.v()));
        p = new BodyPack("gb");
        this.addPack((Pack)p);
        p.add(new Transform("gb.a1", (Transformer)Aggregator.v()));
        p.add(new Transform("gb.cf", (Transformer)ConstructorFolder.v()));
        p.add(new Transform("gb.a2", (Transformer)Aggregator.v()));
        p.add(new Transform("gb.ule", (Transformer)UnusedLocalEliminator.v()));
        p = new BodyPack("gop");
        this.addPack((Pack)p);
        p = new BodyPack("bb");
        this.addPack((Pack)p);
        p.add(new Transform("bb.lso", (Transformer)LoadStoreOptimizer.v()));
        p.add(new Transform("bb.pho", (Transformer)PeepholeOptimizer.v()));
        p.add(new Transform("bb.ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("bb.lp", (Transformer)LocalPacker.v()));
        p.add(new Transform("bb.sco", (Transformer)StoreChainOptimizer.v()));
        p.add(new Transform("bb.ne", (Transformer)NopEliminator.v()));
        p = new BodyPack("bop");
        this.addPack((Pack)p);
        p = new BodyPack("tag");
        this.addPack((Pack)p);
        p.add(new Transform("tag.ln", (Transformer)LineNumberTagAggregator.v()));
        p.add(new Transform("tag.an", (Transformer)ArrayNullTagAggregator.v()));
        p.add(new Transform("tag.dep", (Transformer)DependenceTagAggregator.v()));
        p.add(new Transform("tag.fieldrw", (Transformer)FieldTagAggregator.v()));
        p = new BodyPack("db");
        this.addPack((Pack)p);
        p.add(new Transform("db.transformations", null));
        p.add(new Transform("db.renamer", null));
        p.add(new Transform("db.deobfuscate", null));
        p.add(new Transform("db.force-recompile", null));
        this.onlyStandardPacks = true;
    }

    private void addPack(Pack p) {
        if (this.packNameToPack.containsKey(p.getPhaseName())) {
            throw new RuntimeException("Duplicate pack " + p.getPhaseName());
        }
        this.packNameToPack.put(p.getPhaseName(), p);
        this.packList.add(p);
    }

    public boolean hasPack(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public Pack getPack(String phaseName) {
        Pack p = this.packNameToPack.get(phaseName);
        return p;
    }

    public boolean hasPhase(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public HasPhaseOptions getPhase(String phaseName) {
        int index = phaseName.indexOf(46);
        if (index < 0) {
            return this.getPack(phaseName);
        }
        String packName = phaseName.substring(0, index);
        return this.hasPack(packName) ? this.getPack(packName).get(phaseName) : null;
    }

    public Transform getTransform(String phaseName) {
        return (Transform)this.getPhase(phaseName);
    }

    public Collection<Pack> allPacks() {
        return Collections.unmodifiableList(this.packList);
    }

    public void runPacks() {
        if (Options.v().oaat()) {
            this.runPacksForOneClassAtATime();
        } else {
            this.runPacksNormally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPacksForOneClassAtATime() {
        if (Options.v().src_prec() == 1 && Options.v().keep_line_number()) {
            LineNumberAdder.v().internalTransform("", null);
        }
        this.setupJAR();
        boolean validate = Options.v().validate();
        SourceLocator srcLoc = SourceLocator.v();
        Scene scene = Scene.v();
        for (String path : Options.v().process_dir()) {
            SootClass clazz;
            for (String cl : srcLoc.getClassesUnder(path)) {
                clazz = scene.forceResolve(cl, 2);
                clazz.setApplicationClass();
            }
            for (String cl : srcLoc.getClassesUnder(path)) {
                clazz = null;
                ClassSource source = srcLoc.getClassSource(cl);
                if (source == null) {
                    throw new RuntimeException("Could not locate class source");
                }
                try {
                    clazz = scene.getSootClass(cl);
                    clazz.setResolvingLevel(3);
                    source.resolve(clazz);
                }
                finally {
                    source.close();
                }
                for (SootClass sc : scene.getApplicationClasses()) {
                    if (validate) {
                        sc.validate();
                    }
                    if (sc.isPhantom) continue;
                    ConstantInitializerToTagTransformer.v().transformClass(sc, true);
                }
                this.runBodyPacks(clazz);
                this.writeClass(clazz);
                if (Options.v().no_writeout_body_releasing()) continue;
                this.releaseBodies(clazz);
            }
        }
        this.tearDownJAR();
        this.handleInnerClasses();
    }

    private void runPacksNormally() {
        if (Options.v().src_prec() == 1 && Options.v().keep_line_number()) {
            LineNumberAdder.v().internalTransform("", null);
        }
        if (Options.v().whole_program() || Options.v().whole_shimple()) {
            this.runWholeProgramPacks();
        }
        this.retrieveAllBodies();
        boolean validate = Options.v().validate();
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            if (validate) {
                sc.validate();
            }
            if (sc.isPhantom) continue;
            ConstantInitializerToTagTransformer.v().transformClass(sc, true);
        }
        if (Main.metrics) {
            this.coffiMetrics();
            System.exit(0);
        }
        this.preProcessDAVA();
        if (Options.v().interactive_mode()) {
            if (InteractionHandler.v().getInteractionListener() == null) {
                logger.debug("Cannot run in interactive mode. No listeners available. Continuing in regular mode.");
                Options.v().set_interactive_mode(false);
            } else {
                logger.debug("Running in interactive mode.");
            }
        }
        this.runBodyPacks();
        this.handleInnerClasses();
    }

    public void coffiMetrics() {
        int tV = 0;
        int tE = 0;
        int hM = 0;
        double aM = 0.0;
        HashMap hashVem = CFG.methodsToVEM;
        for (int[] vem : hashVem.values()) {
            tV += vem[0];
            tE += vem[1];
            aM += (double)vem[2];
            if (vem[2] <= hM) continue;
            hM = vem[2];
        }
        if (hashVem.size() > 0) {
            aM /= (double)hashVem.size();
        }
        logger.debug("Vertices, Edges, Avg Degree, Highest Deg:    " + tV + "  " + tE + "  " + aM + "  " + hM);
    }

    public void runBodyPacks() {
        this.runBodyPacks(this.reachableClasses());
    }

    public JarOutputStream getJarFile() {
        return this.jarFile;
    }

    public void writeOutput() {
        this.setupJAR();
        if (Options.v().verbose()) {
            PhaseDumper.v().dumpBefore("output");
        }
        switch (Options.v().output_format()) {
            case 15: {
                this.postProcessDAVA();
                this.outputDava();
                break;
            }
            case 10: 
            case 11: {
                this.writeDexOutput();
                break;
            }
            default: {
                this.writeOutput(this.reachableClasses());
                this.tearDownJAR();
            }
        }
        this.postProcessXML(this.reachableClasses());
        if (!Options.v().no_writeout_body_releasing()) {
            this.releaseBodies(this.reachableClasses());
        }
        if (Options.v().verbose()) {
            PhaseDumper.v().dumpAfter("output");
        }
    }

    protected void writeDexOutput() {
        this.dexPrinter = new DexPrinter();
        this.writeOutput(this.reachableClasses());
        this.dexPrinter.print();
        this.dexPrinter = null;
    }

    private void setupJAR() {
        if (Options.v().output_jar()) {
            String outFileName = SourceLocator.v().getOutputJarName();
            try {
                this.jarFile = new JarOutputStream(new FileOutputStream(outFileName));
            }
            catch (IOException e) {
                throw new CompilationDeathException("Cannot open output Jar file " + outFileName);
            }
        } else {
            this.jarFile = null;
        }
    }

    private void runWholeProgramPacks() {
        if (Options.v().whole_shimple()) {
            ShimpleTransformer.v().transform();
            this.getPack("wspp").apply();
            this.getPack("cg").apply();
            this.getPack("wstp").apply();
            this.getPack("wsop").apply();
        } else {
            this.getPack("wjpp").apply();
            this.getPack("cg").apply();
            this.getPack("wjtp").apply();
            this.getPack("wjop").apply();
            this.getPack("wjap").apply();
        }
        PaddleHook.v().finishPhases();
    }

    private void preProcessDAVA() {
        if (Options.v().output_format() == 15) {
            if (!PhaseOptions.getBoolean((Map)PhaseOptions.v().getPhaseOptions("db"), (String)"source-is-javac")) {
                if (DEBUG) {
                    System.out.println("Source is not Javac hence invoking ThrowFinder");
                }
                ThrowFinder.v().find();
            } else if (DEBUG) {
                System.out.println("Source is javac hence we dont need to invoke ThrowFinder");
            }
            PackageNamer.v().fixNames();
        }
    }

    private void runBodyPacks(Iterator<SootClass> classes) {
        int threadNum = Options.v().num_threads();
        if (threadNum < 1) {
            threadNum = Runtime.getRuntime().availableProcessors();
        }
        CountingThreadPoolExecutor executor = new CountingThreadPoolExecutor(threadNum, threadNum, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        while (classes.hasNext()) {
            SootClass c = classes.next();
            executor.execute(() -> this.runBodyPacks(c));
        }
        try {
            executor.awaitCompletion();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not wait for pack threads to finish: " + e.getMessage(), e);
        }
        Throwable exception = executor.getException();
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    private void handleInnerClasses() {
        InnerClassTagAggregator.v().internalTransform("", null);
    }

    protected void writeOutput(Iterator<SootClass> classes) {
        int threadNum = Options.v().output_format() == 14 && this.jarFile == null ? Runtime.getRuntime().availableProcessors() : 1;
        CountingThreadPoolExecutor executor = new CountingThreadPoolExecutor(threadNum, threadNum, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        while (classes.hasNext()) {
            SootClass c = classes.next();
            executor.execute(() -> this.writeClass(c));
        }
        try {
            executor.awaitCompletion();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not wait for writer threads to finish: " + e.getMessage(), e);
        }
        Throwable exception = executor.getException();
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    private void tearDownJAR() {
        try {
            if (this.jarFile != null) {
                this.jarFile.close();
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("Error closing output jar: " + e);
        }
    }

    private void releaseBodies(Iterator<SootClass> classes) {
        while (classes.hasNext()) {
            this.releaseBodies(classes.next());
        }
    }

    private Iterator<SootClass> reachableClasses() {
        return Scene.v().getApplicationClasses().snapshotIterator();
    }

    private void postProcessDAVA() {
        boolean transformations = PhaseOptions.getBoolean((Map)PhaseOptions.v().getPhaseOptions("db.transformations"), (String)"enabled");
        for (SootClass s : Scene.v().getApplicationClasses()) {
            DavaStaticBlockCleaner.v().staticBlockInlining(s);
            VoidReturnRemover.cleanClass((SootClass)s);
            RemoveEmptyBodyDefaultConstructor.checkAndRemoveDefault((SootClass)s);
            logger.debug("Analyzing " + SourceLocator.v().getFileNameFor(s, Options.v().output_format()) + "... ");
            for (SootMethod m : s.getMethods()) {
                if (!m.hasActiveBody()) continue;
                DavaBody body = (DavaBody)m.getActiveBody();
                if (transformations) {
                    body.analyzeAST();
                    continue;
                }
                body.applyBugFixes();
            }
        }
        if (transformations) {
            InterProceduralAnalyses.applyInterProceduralAnalyses();
        }
    }

    private void outputDava() {
        String pathForBuild = null;
        ArrayList<String> decompiledClasses = new ArrayList<String>();
        for (SootClass s : Scene.v().getApplicationClasses()) {
            String fileName = SourceLocator.v().getFileNameFor(s, Options.v().output_format());
            decompiledClasses.add(fileName.substring(fileName.lastIndexOf(47) + 1));
            if (pathForBuild == null) {
                pathForBuild = fileName.substring(0, fileName.lastIndexOf(47) + 1);
            }
            if (Options.v().gzip()) {
                fileName = fileName + ".gz";
            }
            PrintWriter writerOut = null;
            try {
                OutputStream streamOut;
                if (this.jarFile != null) {
                    this.jarFile.putNextEntry(new JarEntry(fileName.replace('\\', '/')));
                    streamOut = this.jarFile;
                } else {
                    streamOut = new FileOutputStream(fileName);
                }
                if (Options.v().gzip()) {
                    streamOut = new GZIPOutputStream(streamOut);
                }
                writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            }
            catch (IOException e) {
                throw new CompilationDeathException("Cannot output file " + fileName, (Throwable)e);
            }
            logger.debug("Generating " + fileName + "... ");
            DavaPrinter.v().printTo(s, writerOut);
            try {
                writerOut.flush();
                if (this.jarFile == null) {
                    writerOut.close();
                    continue;
                }
                this.jarFile.closeEntry();
            }
            catch (IOException e) {
                throw new CompilationDeathException("Cannot close output file " + fileName);
            }
        }
        if (pathForBuild != null) {
            if (pathForBuild.endsWith("src/")) {
                pathForBuild = pathForBuild.substring(0, pathForBuild.length() - 4);
            }
            String fileName = pathForBuild + "build.xml";
            try (FileOutputStream streamOut = new FileOutputStream(fileName);){
                PrintWriter writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
                DavaBuildFile.generate((PrintWriter)writerOut, decompiledClasses);
                writerOut.flush();
            }
            catch (IOException e) {
                throw new CompilationDeathException("Cannot open output file " + fileName, (Throwable)e);
            }
        }
    }

    private void runBodyPacks(SootClass c) {
        int format = Options.v().output_format();
        if (format == 15) {
            logger.debug("Decompiling {}...", (Object)c.getName());
            G.v().SootMethodAddedByDava = false;
        } else {
            logger.debug("Transforming {}...", (Object)c.getName());
        }
        boolean produceBaf = false;
        boolean produceGrimp = false;
        boolean produceDava = false;
        boolean produceJimple = true;
        boolean produceShimple = false;
        switch (format) {
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                produceShimple = true;
                produceJimple = false;
                break;
            }
            case 15: {
                produceDava = true;
            }
            case 7: 
            case 8: {
                produceGrimp = true;
                break;
            }
            case 5: 
            case 6: {
                produceBaf = true;
                break;
            }
            case 13: 
            case 14: 
            case 17: {
                produceGrimp = Options.v().via_grimp();
                produceBaf = !produceGrimp;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        TagCollector tc = format != 1 && Options.v().xml_attributes() ? new TagCollector() : null;
        boolean wholeShimple = Options.v().whole_shimple();
        if (Options.v().via_shimple()) {
            produceShimple = true;
        }
        for (SootMethod m : new ArrayList(c.getMethods())) {
            if (DEBUG && !m.getExceptions().isEmpty()) {
                System.out.println("PackManager printing out jimple body exceptions for method " + m.toString() + " " + m.getExceptions().toString());
            }
            if (!m.isConcrete()) continue;
            if (produceShimple || wholeShimple) {
                ShimpleBody sBody;
                Body body = m.retrieveActiveBody();
                if (!m.hasActiveBody()) continue;
                if (body instanceof ShimpleBody) {
                    sBody = (ShimpleBody)body;
                    if (!sBody.isSSA()) {
                        sBody.rebuild();
                    }
                } else {
                    sBody = Shimple.v().newBody(body);
                }
                m.setActiveBody((Body)sBody);
                this.getPack("stp").apply((Body)sBody);
                this.getPack("sop").apply((Body)sBody);
                if (produceJimple || wholeShimple && !produceShimple) {
                    m.setActiveBody((Body)sBody.toJimpleBody());
                }
            }
            if (produceJimple) {
                Body body = m.retrieveActiveBody();
                if ("true".equals(System.getProperty("ENABLE_JIMPLE_OPT"))) {
                    this.getTransform("jb.cp").apply(body);
                }
                this.getTransform("jb.cbf").apply(body);
                if ("true".equals(System.getProperty("ENABLE_JIMPLE_OPT"))) {
                    this.getTransform("jb.uce").apply(body);
                    this.getTransform("jb.dae").apply(body);
                    this.getTransform("jb.cp-ule").apply(body);
                }
                this.getPack("jtp").apply(body);
                if (Options.v().validate()) {
                    body.validate();
                }
                this.getPack("jop").apply(body);
                this.getPack("jap").apply(body);
                if (tc != null) {
                    tc.collectBodyTags(body);
                }
            }
            if (!m.hasActiveBody()) continue;
            if (produceGrimp) {
                GrimpBody newBody = Grimp.v().newBody(m.getActiveBody(), "gb");
                m.setActiveBody((Body)newBody);
                this.getPack("gop").apply((Body)newBody);
                continue;
            }
            if (!produceBaf) continue;
            m.setActiveBody((Body)this.convertJimpleBodyToBaf(m));
        }
        if (tc != null) {
            this.processXMLForClass(c, tc);
        }
        if (produceDava) {
            for (SootMethod m : c.getMethods()) {
                if (!m.isConcrete() || !m.hasActiveBody()) continue;
                m.setActiveBody((Body)Dava.v().newBody(m.getActiveBody()));
            }
            if (G.v().SootMethodAddedByDava) {
                for (SootMethod m : G.v().SootMethodsAdded) {
                    c.addMethod(m);
                }
                G.v().SootMethodsAdded = new ArrayList();
                G.v().SootMethodAddedByDava = false;
            }
        }
    }

    public BafBody convertJimpleBodyToBaf(SootMethod m) {
        JimpleBody body = (JimpleBody)m.getActiveBody().clone();
        BafBody bafBody = Baf.v().newBody(body);
        this.getPack("bop").apply((Body)bafBody);
        this.getPack("tag").apply((Body)bafBody);
        if (Options.v().validate()) {
            bafBody.validate();
        }
        return bafBody;
    }

    protected void writeClass(SootClass c) {
        int format = Options.v().output_format();
        switch (format) {
            case 12: 
            case 15: {
                return;
            }
            case 10: 
            case 11: {
                this.dexPrinter.add(c);
                return;
            }
            case 1: {
                if (c.isPhantom) break;
                ConstantValueToInitializerTransformer.v().transformClass(c);
                break;
            }
        }
        if (!"true".equals(System.getProperty("ENABLE_WRITECLASS"))) {
            return;
        }
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        if (Options.v().gzip()) {
            fileName = fileName + ".gz";
        }
        OutputStream streamOut = null;
        PrintWriter writerOut = null;
        try {
            if (this.jarFile != null) {
                fileName = fileName.replace("\\", "/");
                JarEntry entry = new JarEntry(fileName);
                entry.setMethod(8);
                this.jarFile.putNextEntry(entry);
                streamOut = this.jarFile;
            } else {
                new File(fileName).getParentFile().mkdirs();
                streamOut = new FileOutputStream(fileName);
            }
            if (Options.v().gzip()) {
                streamOut = new GZIPOutputStream(streamOut);
            }
            if (format == 14 && Options.v().jasmin_backend()) {
                streamOut = new JasminOutputStream(streamOut);
            }
            writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            logger.debug("Writing to " + fileName);
        }
        catch (IOException e) {
            throw new CompilationDeathException("Cannot output file " + fileName, (Throwable)e);
        }
        if (Options.v().xml_attributes()) {
            Printer.v().setOption(16);
        }
        switch (format) {
            case 14: {
                if (!Options.v().jasmin_backend()) {
                    this.createASMBackend(c).generateClassFile(streamOut);
                    break;
                }
            }
            case 13: {
                this.createJasminBackend(c).print(writerOut);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                Printer.v().setOption(1);
                Printer.v().printTo(c, writerOut);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                writerOut = new PrintWriter((Writer)new EscapedWriter((Writer)new OutputStreamWriter(streamOut)));
                Printer.v().printTo(c, writerOut);
                break;
            }
            case 9: {
                writerOut = new PrintWriter((Writer)new EscapedWriter((Writer)new OutputStreamWriter(streamOut)));
                XMLPrinter.v().printJimpleStyleTo(c, writerOut);
                break;
            }
            case 16: {
                writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
                TemplatePrinter.v().printTo(c, writerOut);
                break;
            }
            case 17: {
                this.createASMBackend(c).generateTextualRepresentation(writerOut);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        try {
            writerOut.flush();
            if (this.jarFile == null) {
                streamOut.close();
                writerOut.close();
            } else {
                this.jarFile.closeEntry();
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("Cannot close output file " + fileName);
        }
    }

    private AbstractJasminClass createJasminBackend(SootClass c) {
        if (c.containsBafBody()) {
            return new soot.baf.JasminClass(c);
        }
        return new JasminClass(c);
    }

    protected BafASMBackend createASMBackend(SootClass c) {
        return new BafASMBackend(c, Options.v().java_version());
    }

    private void postProcessXML(Iterator<SootClass> classes) {
        if (!Options.v().xml_attributes() || Options.v().output_format() != 1) {
            return;
        }
        while (classes.hasNext()) {
            SootClass c = classes.next();
            this.processXMLForClass(c);
        }
    }

    private void processXMLForClass(SootClass c, TagCollector tc) {
        int ofmt = Options.v().output_format();
        int format = ofmt != 12 ? ofmt : 1;
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        XMLAttributesPrinter xap = new XMLAttributesPrinter(fileName, SourceLocator.v().getOutputDir());
        xap.printAttrs(c, tc);
    }

    private void processXMLForClass(SootClass c) {
        int format = Options.v().output_format();
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        XMLAttributesPrinter xap = new XMLAttributesPrinter(fileName, SourceLocator.v().getOutputDir());
        xap.printAttrs(c);
    }

    private void releaseBodies(SootClass cl) {
        Iterator methodIt = cl.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m = (SootMethod)methodIt.next();
            if (!m.hasActiveBody()) continue;
            m.releaseActiveBody();
        }
    }

    private void retrieveAllBodies() {
        int threadNum = Options.v().coffi() ? 1 : Runtime.getRuntime().availableProcessors();
        CountingThreadPoolExecutor executor = new CountingThreadPoolExecutor(threadNum, threadNum, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        Iterator<SootClass> clIt = this.reachableClasses();
        while (clIt.hasNext()) {
            SootClass cl = clIt.next();
            for (SootMethod m : new ArrayList(cl.getMethods())) {
                if (!m.isConcrete()) continue;
                executor.execute(() -> m.retrieveActiveBody());
            }
        }
        try {
            executor.awaitCompletion();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not wait for loader threads to finish: " + e.getMessage(), e);
        }
        Throwable exception = executor.getException();
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }
}

