## 公开测试样例

六个公开测试样例占本次Lab总分数的54%，每个占9%。这些测试样例难度较低，只要实现了相应的基本分析规则即可通过。公开的六个测试样例放在judge/global/tests目录下。以下按照难度递增的顺序，对六个样例做出简要说明。

### Hello

```java
public class Hello {
  public static void main(String[] args) {
    Benchmark.alloc(3); 
    B b = new B();
    Benchmark.test(7, b); 
  }
}
/*
Answer:
  7 : 3
*/
```

这组测试样例要求你的分析器实现基本功能：你的分析器需要正确地收集`Benchmark.alloc`和`Benchmark.test`的信息、正确地输出答案，并且该过程不崩溃、不超时。值得注意的是，`Benchmark.alloc`和`Benchmark.test`未必是从1开始的连续正整数编号。

### Branch

```java
public class Branch {
  public static void main(String[] args) {
    Benchmark.alloc(1); 
    B b1 = new B();
    Benchmark.alloc(2);
    B b2 = new B();
    if(args.length > 1) b2 = b1;
    Benchmark.test(1, b1); 
    Benchmark.test(2, b2);
  }
}
/*
Answer:
  1 : 1
  2 : 1 2
*/
```

这组测试样例要求你的分析器处理变量赋值和`if`条件分支：你的分析器应能正确处理控制流的合并。

### Loop

```java
public class Loop {
  public static void main(String[] args) {
    Benchmark.alloc(1); 
    B b1 = new B();
    Benchmark.alloc(2);
    B b2 = new B();
    Benchmark.alloc(3);
    B b3 = new B();
    Benchmark.alloc(4);
    B b4 = new B();
    for(int i = 0; i < args.length; i++) {
        b1 = b2;
        b2 = b3;
        b3 = b4;
    }
    Benchmark.test(1, b1); 
    Benchmark.test(2, b2);
    Benchmark.test(3, b3); 
    Benchmark.test(4, b4);
  }
}
/*
Answer:
  1 : 1 2 3 4
  2 : 2 3 4
  3 : 3 4
  4 : 4
*/
```

这组测试样例要求你的分析器处理`while`循环：你可能需要一些机制来保证算法必要的迭代次数。

### Invocation

```java
public class Invocation {
    public static class Obj {
      public Obj() {}
      public Obj f1() { return this; }
    }
    public static Obj f2(Obj a1) {
      Benchmark.test(1, a1); 
      Benchmark.alloc(2);
      Obj a2 = new Obj();
      return a2;
    }
    public static void main(String[] args) {
      Benchmark.alloc(1);
      Obj a3 = new Obj();
      Obj a4 = f2(a3);
      Benchmark.test(2, a4);
      Obj a5 = a4.f1();
      Benchmark.test(3, a5);
    }
}
/*
Answer:
  1 : 1
  2 : 2
  3 : 2
*/
```

这组测试样例要求你的分析器处理方法调用(Method Invocation)：你的分析器应能跟踪通过方法调用（和返回）传递的对象引用。

### Field1

```java
// class A存放在Tai-e/src/test/pku/benchmark/A.java
public class A {
	// Object A with attributes of type B
	// ...
	public B f = new B();
	// ...
	public A() {  }
}

public class Field1 {
  public static void main(String[] args) {
    A a1 = new A();
    A a2 = a1;
    Benchmark.alloc(1);
    B b1 = new B();
    Benchmark.alloc(2);
    B b2 = new B();
    Benchmark.alloc(3); 
    B b3 = new B(); 
    a1.f = b1;
    if(args.length > 1) a2.f = b2;
    B b4 = a1.f;
    Benchmark.test(1, b4); 
    B b5 = a2.f;
    Benchmark.test(2, b5); 
  }
}
/*
Answer: 
  1 : 1 2
  2 : 1 2
*/
```

这组测试样例要求你的分析器处理Field操作，包括Field Storing和Field Loading。

前四个测试样例中，Object只有平凡的结构(类似于integer, 没有特别复杂的内部结构)。到了这里，Object内部的Field可能也是一个指针。你可能需要重新思考一个最根本的问题：在我们的指针分析中，什么是pointer，以及什么是pointee (object)？

### Field2

```java
// class A与上一组样例相同
public class Field2 {
  public static void main(String[] args) {
    A a1 = new A();
    A a2 = new A();
    Benchmark.alloc(1);
    B b1 = new B();
    Benchmark.alloc(2);
    B b2 = new B();
    a1.f = b1;
    if(args.length > 1) a2.f = b2;
    B b3 = a1.f;
    Benchmark.test(1, b3); 
    B b4 = a2.f;
    Benchmark.test(2, b4); 
  }
}
/*
Answer: 
  1 : 1
  2 : 2
*/
```

这组测试样例要求你的分析器具有一定的Field Sensitivity，即不同对象的字段需要做出区分。
